/**
 * Beschrijft een lift die een onbeperkt aantal mensen kan bevatten, maar
 * die samen het maximumgewicht niet mogen overschrijden.
 *
 * @author Dominiek Vandewalle
 * @version 2014-11-10
 */
import java.util.ArrayList;

public class Lift
{
    private int maxGewicht;//Maximum gewicht dat de lift kan dragen.
    private ArrayList<Persoon> lifters;//Lijst van personen in de lift.

    /**
     * Constructor voor objecten van de klasse Lift.
     * @param   maxGewicht  Het gewicht dat de lift maximaal kan dragen.
     */
    public Lift(int maxGewicht)
    {
        this.maxGewicht = maxGewicht;
        lifters = new ArrayList<Persoon>();
    }

    /**
     * Geeft het gewicht dat de lift maximaal kan dragen terug.
     * @return  Het maximaal gewicht.
     */
    public int getMaxGewicht()
    {
        return maxGewicht;
    }

    /**
     * Berekent het totaal gewicht van alle personen in de lift.
     * @return  Het totaal gewicht van de personen in de lift.
     */
    public int berekenGewichtInLift()
    {
        int totaalGewicht = 0;

        for(Persoon lifter: lifters)
        {
            totaalGewicht += lifter.getGewicht();
        }

        return totaalGewicht;
    }

    /**
     * Berekent het aantal vrouwen in de lift.
     * @return  Het aantal vrouwen in de lift.
     */
    public int aantalVrouwen()
    {
        int aantalVrouwen = 0;

        for(Persoon lifter: lifters)
        {
            if(lifter.getIsVrouw())
            {
                aantalVrouwen++;
            }
        }

        return aantalVrouwen;
    }

    /**
     * Laat een persoon in de lift stappen op voorwaarde dat het
     * maximumgewicht niet overschreden wordt.
     * @param   lifter  De persoon die in de lift wil stappen.
     */
    public void stapInLift(Persoon lifter)
    {
        if((berekenGewichtInLift() + lifter.getGewicht()) <= maxGewicht)
        {
            lifters.add(lifter);
        }
    }

    /**
     * Laat een persoon op een gegeven index uit de lift stappen
     * @param   De index van de persoon in de lift die wenst uit te stappen.
     */
    public void stapUitLift(int index)
    {
        if(index >= 0 && index < lifters.size())
        {
            lifters.remove(index);
        }
    }

    /**
     * Laat een persoon uit de lift stappen.
     * @param   lifter  De persoon die de lift verlaat.
     */
    public void stapUitLift(Persoon lifter)
    {
        lifters.remove(lifter);
    }

    /**
     * Geeft een verwijzing naar een lifter op een gegeven index in de lift terug.
     * @param   index   De index van de lifter waar je een verwijzing naar wenst.
     * @return  Een verwijzing naar de gevraagde lifter of, indien de index ongeldig is, null.
     */
    public Persoon geefLifter(int index)
    {
        Persoon lifter = null;

        if(index >= 0 && index < lifters.size())
        {
            lifter = lifters.get(index);
        }

        return lifter;
    }

    /**
     * Controleer of er een vrouw aanwezig is in de lift.
     * @return  True indien er een vrouw aanwezig is, anders false.
     */
    public boolean vrouwAanwezig()
    {
        int index = 0;

        while(index < lifters.size() && ! lifters.get(index).getIsVrouw())
        {
            index++;
        }   

        return index < lifters.size();
    }

    /**
     * Toont alle informatie over de lift in het terminalvenster.
     */
    public void printLift()
    {
        String info = "";
        
        for(Persoon lifter : lifters)
        {
            if(lifter.getIsVrouw())
            {
                info = "Vrouw - ";
            }
            else
            {
                info = "Man - ";
            }
            
            info += lifter.getGewicht() + " kg";
            System.out.println(info);
        }

        System.out.println("Belasting lift: " + berekenGewichtInLift() + "/" + maxGewicht);
    }
}
